//
//  NSDate+OnePassword.h
//  ApplicationFrameworks
//
//  Created by Michael Fey on 8/7/14.
//
//

#import <Foundation/Foundation.h>

@interface NSDate (OnePassword)

/*!
 @method
 @abstract Returns human readable time like "1 min ago", "2 day ago", etc
 */
- (NSString *)ag_ago;

/*!
 @method
 @abstract These methods are to be used with OPDateField. 
 Modern dates are accurate to the day, but have extra information encoded into the time component.
 */
- (BOOL)op_isModernDate;
- (NSDate *)op_modernDateWithDayInTimeZone:(NSTimeZone *)timeZone;

/*!
 @method
 @abstract These methods are to be used with OPDateField.
 Formats the day in short style without a time in the UTC timezone if it's a modern date.
 */
- (NSString *)op_formatDate;

@end